/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Sound
**
** DESCRIPTION:	Sound effects
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SOUND_H
#define SOUND_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwSound.h"

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ESound
{
	eSound_None = -1,

	eSound_Babygurgle2,
	eSound_Beaker,
	eSound_BIRD1,
	eSound_Bird1b,
	eSound_BIRD2,
	eSound_Bird2b,
	eSound_Bird3,
	eSound_Bird4,
	eSound_Bird5b,
	eSound_Bird6,
	eSound_Bird7,
	eSound_Bush3,
	eSound_Chimeslow,
	eSound_Chiselloop,
	eSound_Cough1,
	eSound_Cough2,
	eSound_Cough3,
	eSound_FemaleSneeze,
	eSound_FemaleCough,
	eSound_Creek,
	eSound_Rain,
	eSound_Dirt,
	eSound_DirtCrunch2,
	eSound_Drip,
	eSound_Fire,
	eSound_SmokingStick,
	eSound_Hammerwoodloop,
	eSound_Kiss,
	eSound_Menubutton3,
	eSound_Msg_gratz,
	eSound_OCEAN,

	eSound_Femaleno_First,
	eSound_Femaleno2,		
	eSound_Femaleno3,		
	eSound_Femaleno4,		
	eSound_Femaleno5,		
	eSound_Femaleno6,		
	eSound_Femaleno7,		
	eSound_Femaleno8,		
	eSound_Femaleno9,		
	eSound_Femaleno10,		
	eSound_Femaleno_Last,	

	eSound_Maleno_First,	
	eSound_Maleno2,			
	eSound_Maleno3,			
	eSound_Maleno4,			
	eSound_Maleno5,			
	eSound_Maleno6,			
	eSound_Maleno7,			
	eSound_Maleno8,			
	eSound_Maleno9,			
	eSound_Maleno_Last,		

	eSound_Ohkid_First,
	eSound_Ohkid2,
	eSound_Ohkid3,
	eSound_Ohkid4,
	eSound_Ohkid5,
	eSound_Ohkid6,
	eSound_Ohkid7,
	eSound_Ohkid8,
	eSound_Ohkid9,
	eSound_Ohkid10,
	eSound_Ohkid11,
	eSound_Ohkid12,
	eSound_Ohkid_Last,

	eSound_Ohman_First,
	eSound_Ohman2,
	eSound_Ohman3,
	eSound_Ohman4,
	eSound_Ohman5,
	eSound_Ohman6,
	eSound_Ohman7,
	eSound_Ohman8,
	eSound_Ohman9,
	eSound_Ohman10,
	eSound_Ohman11,
	eSound_Ohman12,
	eSound_Ohman_Last,

	eSound_Ohwoman_First,
	eSound_Ohwoman2,
	eSound_Ohwoman3,
	eSound_Ohwoman4,
	eSound_Ohwoman5,
	eSound_Ohwoman6,
	eSound_Ohwoman7,
	eSound_Ohwoman8,
	eSound_Ohwoman_Last,

	eSound_Splash1,
	eSound_Spray,
	eSound_Stoneb,
	eSound_Wind,
	eSound_TinyChime,

	eSound_BongoHollow,
	eSound_BongoFlick,
	eSound_Gong,
	eSound_Bongo4,
	eSound_Bongo5,
	eSound_Bongo6,
	eSound_Bongo7,
	eSound_Bongo8,
	eSound_Tap,
	eSound_LowDrum,
	eSound_Angel,

	eSound_Testtube,
	eSound_SparkleWeld,
	eSound_Parrots,
	eSound_FireWhoosh,
	eSound_TearingBranches,
	eSound_Scraping,
	eSound_Eating,
	eSound_Drinking,
	eSound_Whistling,
	eSound_Sweeping,
	eSound_Crowds,

	eSound_Chimes1,
	eSound_Chimes2,
	eSound_Giggles,
	eSound_Digging1,
	eSound_Digging2,
	eSound_Carving1,
	eSound_Carving2,

	eSound_Belch,
	eSound_Mumble,
	eSound_Hicup,

	eSound_Gong2,
	eSound_Cooking,
	eSound_ChimesLow2,
	eSound_ChimesTiny2,
	eSound_ChimesMysterious,
	eSound_Bees,
	eSound_Lightning,
	eSound_Thunder,
	eSound_Masonry,
	eSound_TwistedChimes,
	eSound_Clamsnap,
	eSound_BirdsLoop,

	eSound_Narrator_Intro1,
	eSound_Narrator_Intro2,
	eSound_Narrator_Intro3,
	eSound_Narrator_Intro4,
	eSound_Narrator_MidGame1,
	eSound_Narrator_MidGame2,
	eSound_Narrator_MidGame3,
	eSound_Narrator_End1,
	eSound_Narrator_End2,
	eSound_Narrator_End3,
	eSound_Narrator_End4,

	eSound_NumberOf,

	eSound_OhKid_Count    = ((eSound_Ohkid_Last - eSound_Ohkid_First) + 1),
	eSound_OhMan_Count    = ((eSound_Ohman_Last - eSound_Ohman_First) + 1),
	eSound_MaleNo_Count   = ((eSound_Maleno_Last - eSound_Maleno_First) + 1),
	eSound_OhWoman_Count  = ((eSound_Ohwoman_Last - eSound_Ohwoman_First) + 1),
	eSound_FemaleNo_Count = ((eSound_Femaleno_Last - eSound_Femaleno_First) + 1)
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSound
{
private:
    
	//class structures
	struct SSound
	{
		ldwSoundFx *	m_pSound;
		bool			m_bIsLooping;
		float			m_fVolume;
	};

	//class data
	static char *		m_sSoundFile[eSound_NumberOf];
	SSound				m_sSound[eSound_NumberOf];

	float				m_fMasterVolume;
	
public:

	//class methods
	//setup
	public:		CSound();
	public:		~CSound();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	//process
	public:		void Play(const ESound eSound);
	public:		void Play(const ESound eSound, const bool bIsLooping);
	public:		void Play(const ESound eSound, const float fVolume);
	public:		void Play(const ESound eSound, const bool bIsLooping, const float fVolume);
	public:		void Stop(const ESound eSound = eSound_None);
	public:		void Pause();
	public:		void Resume();
	public:		void Release(const ESound eSound);

	//access
	public:		void SetVolume(const float fMasterVolume) { m_fMasterVolume = fMasterVolume; }
	public:		void SetVolume(const ESound eSound, const float fVolume);
	public:		ldwSoundFx *GetSound(const ESound eSound) { return m_sSound[eSound].m_pSound; }

	public:     const char* GetESoundName(const ESound eSound);
	public:		const bool IsPlaying(const ESound eSound) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSound		Sound;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/